package editor;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class StartOfLevelRoomSelectWizard extends JPanel {
	
	private JDialog frame;
	private MainEditorPanel mainPanel;
	private boolean wasCancelled = true;
	private JComboBox selections;
	
	public StartOfLevelRoomSelectWizard(JDialog theFrame, MainEditorPanel theMainPanel) {
		
		mainPanel = theMainPanel;
		frame = theFrame;
		
		this.setLayout(new BorderLayout());
		
		ArrayList<String> theRoomNames = mainPanel.getListOfRoomNames();
		
		selections = new JComboBox();
		for(String s : theRoomNames) {
			selections.addItem(s);
			//System.out.println("Adding item: " + s);
		}
		
		JPanel centerPanel = new JPanel(new FlowLayout());
		centerPanel.add(selections);
		
		this.add(centerPanel, BorderLayout.CENTER);
		
		
		JPanel lowerPanel = new JPanel(new GridLayout(1, 4));
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				cancel();
			}
		});
		lowerPanel.add(cancel);
		
		lowerPanel.add(new JPanel());
		lowerPanel.add(new JPanel());
		
		JButton ok = new JButton("OK");
		ok.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				ok();
			}
		});
		lowerPanel.add(ok);
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		
	}
	
	private void cancel() {
		wasCancelled = true;
		frame.dispose();
	}
	
	private void ok() {
		
		String selectedRoomName = (String) selections.getSelectedItem();
		
		if(selectedRoomName == null) {
			JOptionPane.showMessageDialog(frame, "Nothing was selected.","Selection Error", JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		RoomEditorPanel selection = mainPanel.getRoomByName(selectedRoomName);
		
		if(selection == null) {
			JOptionPane.showMessageDialog(frame, "Someone changed the room names under this dialog's nose!  Closing...!","Selection Error", JOptionPane.WARNING_MESSAGE);
			cancel();
		}
		
		
		mainPanel.setAllRoomsToNotBeStart();
		selection.setStartRoom(true);
		
		mainPanel.repaint();
		selection.repaint();
		
		frame.dispose();
		
	}
	
}
